import React from 'react'
import Navbar from '../components/Navbar'
import Footer from '../components/Footer'

const Services = () => {

    return (
        <div>
            <Navbar />
            <div className='services-banner'></div>

            <section className="services py-5">
                <div className="container">
                    <h2 className="font-weight-bold mb-4 text-center text-black">OUR SERVICES</h2>

                    {/* Residential Lighting */}
                    <div className="row mb-4 align-items-center my-5">
                        <div className="col-md-6">
                            <div className="service-item mb-4">
                                <h3 className="text-warning font-weight-bold">RESIDENTIAL LIGHTING</h3>
                                <p>At Arabian Lights, we offer a wide range of lighting products designed to illuminate your living spaces with elegance and sophistication. From modern chandeliers that serve as stunning focal points in dining rooms to LED strip lights that can be installed in various locations for accent lighting, our selection is tailored to meet the unique needs of each home.
                                </p>
                                <p>
                                    Our products not only enhance the comfort and aesthetics of homes across Qatar but also promote energy efficiency and sustainability. We understand that lighting plays a crucial role in setting the mood and atmosphere in your home, which is why we offer personalized consultations to help you choose the perfect fixtures that align with your style and functionality requirements.
                                </p>
                            </div>
                        </div>
                        <div className="col-md-6 text-center image-div">
                            <div className="card image-card">
                                <div className="image-container">
                                    <img
                                        src="/images/Picture1.jpg"
                                        className="card-img-top img-fluid landscape-image"
                                        alt="Strip Lights"
                                    />
                                </div>
                            </div>
                        </div>
                    </div>

                    {/* Commercial Lighting */}
                    <div className="row mb-4 align-items-center my-5">
                        <div className="col-md-6 text-center">
                            <div className="card image-card">
                                <div className="image-container">
                                    <img
                                        src="/images/333.png"
                                        className="card-img-top img-fluid landscape-image"
                                        alt="Profile Lighting"
                                    />
                                </div>
                            </div>
                        </div>
                        <div className="col-md-6">
                            <div className="service-item mb-4">
                                <h3 className="text-warning font-weight-bold">COMMERCIAL LIGHTING</h3>
                                <p>Our portfolio includes advanced lighting systems specifically designed for a wide array of commercial environments, including offices, retail outlets, hospitality venues, warehouses, and mosques. We focus on creating optimal environments that enhance productivity and customer satisfaction. Our commercial lighting solutions include energy-efficient LED fixtures, smart lighting controls, and task-oriented designs that ensure proper illumination where it is needed most. </p>
                                <p>
                                    By prioritizing functionality and aesthetics, we help businesses improve their ambiance, increase employee well-being, and create inviting spaces for customers. Partnering with us means investing in quality lighting that not only meets industry standards but also enhances your brand’s identity.
                                </p>
                            </div>
                        </div>
                    </div>

                    {/* Maintenance & Support */}
                    <div className="row mb-4 align-items-center my-5">
                        <div className="col-md-6">
                            <div className="service-item mb-4">
                                <h3 className="text-warning font-weight-bold">MAINTENANCE & SUPPORT</h3>
                                <p>Arabian Lights offers comprehensive maintenance services to ensure that all lighting systems operate at peak efficiency and with minimal downtime. Our experienced technicians are dedicated to providing ongoing support, including regular inspections, troubleshooting, and prompt repairs. We believe that proper maintenance is key to extending the lifespan of your lighting systems, reducing long-term costs, and maintaining optimal performance. </p>
                                <p>
                                    Whether you need routine check-ups for your residential setup or a tailored maintenance plan for your commercial establishment, we are here to ensure that your lighting remains in excellent condition. Our commitment to quality service guarantees peace of mind, allowing you to focus on what truly matters.
                                </p>
                            </div>
                        </div>
                        <div className="col-md-6 text-center">
                            <div className="card image-card">
                                <div className="image-container">
                                    <img
                                        src="/images/444.png"
                                        className="card-img-top img-fluid landscape-image"
                                        alt="Track Lights"
                                    />
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </section>

            <Footer />
        </div>
    )
}

export default Services
