import React from 'react'
import Navbar from '../components/Navbar'
import Footer from '../components/Footer'

const Products = () => {
    const galleryItems = [
        {
            id: 1,
            imgSrc: '/images/PROFILE-LIGHTING.jpeg',
            title: 'PROFILE-LIGHTING',
            alt: 'PROFILE-LIGHTING'
        },
        {
            id: 2,
            imgSrc: '/images/TRACK-LIGHTS.jpeg',
            title: 'TRACK-LIGHTS',
            alt: 'TRACK-LIGHTS'
        },
        {
            id: 3,
            imgSrc: '/images/STRIP-LIGHTS.png',
            title: 'STRIP-LIGHTS',
            alt: 'STRIP-LIGHTS'
        },
        {
            id: 4,
            imgSrc: '/images/IMSGE.jpeg',
            title: 'SPOT LIGHTS',
            alt: 'Outdoor Lamps'
        },
        {
            id: 5,
            imgSrc: '/images/LAMPS.png',
            title: 'LAMPS',
            alt: 'Outdoor Lamps'
        },
        {
            id: 6,
            imgSrc: '/images/INDUSTRIAL-LIGHTS.jpeg',
            title: 'INDUSTRIAL-LIGHTS',
            alt: 'Outdoor Lamps'
        },
        {
            id: 7,
            imgSrc: '/images/LED-DRIVERS.jpeg',
            title: 'LED-DRIVERS',
            alt: 'Outdoor Lamps'
        },
        {
            id: 8,
            imgSrc: '/images/EMERGENCY-LIGHTS.jpg',
            title: 'EMERGENCY-LIGHTS',
            alt: 'Outdoor Lamps'
        },
        {
            id: 9,
            imgSrc: '/images/EMERGENCY-BACKUP-KITS.jpeg',
            title: 'EMERGENCY-BACKUP-KITS',
            alt: 'Outdoor Lamps'
        },
        {
            id: 10,
            imgSrc: '/images/EXIT-LIGHTS.png',
            title: 'EXIT-LIGHTS',
            alt: 'Outdoor Lamps'
        },
        {
            id: 12,
            imgSrc: '/images/WIRING-ACCESORIES.jpg',
            title: 'WIRING-ACCESORIES',
            alt: 'Outdoor Lamps'
        },
        {
            id: 12,
            imgSrc: '/images/OUTDOOR-LIGHTS.jpg',
            title: 'OUTDOOR-LIGHTS',
            alt: 'Outdoor Lamps'
        },
    ];
    return (
        <div>
            <Navbar />
            <div className='product-banner'></div>
            <div className="product container my-5 pt-5">
                <h2 className="font-weight-bold mb-4 text-center">OUR PRODUCTS</h2>
                <div className="row text-center">
                    {/* Map through the gallery items */}
                    {galleryItems.map(item => (
                        <div className="col-md-4 p-4" key={item.id}>
                            <div className="card">
                                <img src={item.imgSrc} className="card-img-top " alt={item.alt} />
                                <div className="card-body mx-5">
                                    <h5 className="card-title font-family">{item.title}</h5>
                                    <hr />
                                </div>
                            </div>
                        </div>
                    ))}
                </div>

            </div>
            <Footer />
        </div>
    )
}

export default Products
