import Head from "next/head";
import Navbar from "../components/Navbar"
import HomeBanner from "../components/Homepage/HomeBanner"
import Footer from "../components/Footer"
import Gallery from "../components/Homepage/Gallery"
import AboutSummary from "../components/Homepage/AboutSummary"
import OurServicesSummary from "../components/Homepage/OurServicesSummary"
import PartnersSample from "../components/Homepage/PartnersSample"
import "slick-carousel/slick/slick.css"; 
import "slick-carousel/slick/slick-theme.css";

// import 'bootstrap/dist/css/bootstrap.min.css';
// import 'bootstrap/dist/js/bootstrap.bundle.min.js';
// import dynamic from 'next/dynamic';
// const Bootstrap = dynamic(() => import('bootstrap/dist/js/bootstrap.bundle.min.js'), { ssr: false });
// Dynamically import Bootstrap JS only on the client side


export default function Home() {
  return (
    <>
    
      <Head>
        <title>Arabian Lights</title>
        <meta name="description" content="Arabian Lights specializes in providing high-quality lighting solutions and decorative lights that enhance the beauty and functionality of any space." />
        <meta name="viewport" content="width=device-width, initial-scale=1" />
        <link rel="icon" href="/favicon.ico" />
       
      </Head>
      <Navbar />
      <HomeBanner/>
      <Gallery/>
      <AboutSummary/>
      <OurServicesSummary/>
      <PartnersSample/>
      <Footer/>

    </>
  );
}
