import "@/styles/globals.css";
import type { AppProps } from "next/app";
import '@/styles/styles.css';
import Head from "next/head";
import FloatingContacts from "@/components/FloatingContacts"


export default function App({ Component, pageProps }: AppProps) {
  return(
    <>
     <Head>
        <title>Arabian Lights</title>
        <meta name="description" content="Arabian Lights specializes in providing high-quality lighting solutions and decorative lights that enhance the beauty and functionality of any space." />
        <meta name="viewport" content="width=device-width, initial-scale=1" />
        <link rel="icon" href="/favicon.ico" />
       
      </Head>
    <Component {...pageProps} />
    <FloatingContacts />
    </>
  ) 
}
