"use-client"
import React, {useState, useEffect} from 'react'
import Link from 'next/link';
import { useRouter } from 'next/router';

const Navbar = () => {

const router = useRouter();


    const menu = [
        {
            path: '/',
            name: 'Home',

        },
        {
            path: '/about',
            name: 'About Us',

        },
        // {
        //     path: '/services',
        //     name: 'Services',

        // },
        {
            path: '/products',
            name: 'Products',   

        },
        {
            path: '/our-partners',
            name: 'Partners',

        },

        {
            path: '/contact',
            name: 'Contact',

        }

    ]

    const [isScrolled, setIsScrolled] = useState(false);

    useEffect(() => {
        const handleScroll = () => {
            setIsScrolled(window.scrollY > 0);
        };

        window.addEventListener('scroll', handleScroll);
        return () => {
            window.removeEventListener('scroll', handleScroll);
        };
    }, []);

    return (
        <>
            {/* <div className='bg-dark text-white'>
                <div className='container upper-nav py-2 mx-lg-5 mx-md-2 ' >
                    <div class="row">
                        <div class="col-12 d-flex align-items-center">
                            <i class='bx bxs-phone-call' style={{ color: '#D19204', margin: '3px', fontSize: '20px' }}></i>
                            <span>+974 5599 3375 | +974 7036 9959</span>
                        </div>
                        <div class="col-12 d-flex align-items-center">
                            <i class='bx bxs-envelope' style={{ color: '#D19204', marginRight: '5px', fontSize: '20px' }}></i>
                            <span>arabian.lights@outlook.com</span>
                        </div>
                    </div>




                    
                </div>
            </div> */}
            <div class="bg-dark text-white py-2 ">
                <div class="container ">
                    <div class="row justify-content-center align-items-center">
                        <div class="col-auto d-flex align-items-center">
                            <i class='bx bxs-phone-call text-warning me-2'  style={{ color: '#D19204', margin: '3px', fontSize: '20px' }}></i>
                            <span>+974 5599 3375 | +974 7212 3843</span>
                        </div>
                        <div class="col-auto d-flex align-items-center ms-4">
                            <i class='bx bxs-envelope text-warning me-2' style={{ color: '#D19204', marginRight: '5px', fontSize: '20px' }}></i>
                            <span>arabian.lights@outlook.com</span>
                        </div>
                    </div>
                    <hr style={{ backgroundColor: 'white', margin:0, marginTop:'10px' }} />
                </div>
            </div>

            <div >
                
            <nav
            className={`bg-dark navbar navbar-expand-lg fixed-top ${isScrolled ? 'scrolled' : 'top-space'} `}
            data-bs-theme="dark"
        >
            <div className="container-fluid">
                <Link className="navbar-brand" href="/">
                    <img className="logo mx-lg-5" src="/images/LOGO-AL-BLACK.png" style={{ height: '60px' }} />
                </Link>
                <button
                    className="navbar-toggler"
                    type="button"
                    data-bs-toggle="collapse"
                    data-bs-target="#navbarSupportedContent"
                    aria-controls="navbarSupportedContent"
                    aria-expanded="false"
                    aria-label="Toggle navigation"
                >
                    <span className="navbar-toggler-icon"></span>
                </button>
                <div className="collapse navbar-collapse mx-lg-5" id="navbarSupportedContent">
                    <ul className="navbar-nav ms-auto">
                        {menu.map((item, index) => (
                            <li className="nav-item me-4" key={index}>
                                <Link
                                    href={item.path}
                                    className={`nav-link text-white menu-item ${router.pathname === item.path ? 'active' : ''}`}
                                >
                                    {item.name}
                                </Link>
                            </li>
                        ))}
                    </ul>
                </div>
            </div>
        </nav>

            </div>

        </>
    )
}

export default Navbar