import Link from 'next/link'
import React from 'react'
import DividerBanner from '../DividerBanner'

const PartnersSample = () => {
    const clients = [
        {
            id: 0,
            uri: '/images/2560px-Ledvance_logo.svg.png',
        },
        {
            id: 1,
            uri: '/images/ABB_logo-6.png',
        },
        {
            id: 2,
            uri: '/images/Elmark-logo-1-e1608046071382.png',
        },
        {
            id: 3,
            uri: '/images/Philips_logo_new.svg.png',
        },
        {
            id: 4,
            uri: '/images/tungsram_logo1.png',
        }

    ]

    return (
        <div>
            <DividerBanner />
            <div className="container my-5">
                <div className="row justify-content-center align-items-center ">
                    <h2 className="text-center mb-4 ">Our Partners</h2>
                    {clients.map((item, index) => (
                        <div className="col-6 col-sm-4 col-md-3 col-lg-2 text-center my-5" key={index}>
                            <img className="client-icon img-fluid" src={item.uri} alt={`client-icon-${index}`} />
                        </div>
                    ))}
                    <div className="d-flex justify-content-center my-4">

                        <Link href='/our-partners'>
                            <button className='button ' style={{ borderRadius: '0' }}>See More</button>
                        </Link>

                    </div>

                </div>
            </div>
        </div>

    )
}

export default PartnersSample
