import Link from 'next/link';
import React from 'react';

const Gallery = () => {
    // Array of gallery items
    const galleryItems = [
        {
            id: 1,
            imgSrc: '/images/PROFILE-LIGHTING.jpeg',
            title: 'PROFILE-LIGHTING',
            alt: 'Chandeliers'
        },
        {
            id: 2,
            imgSrc: '/images/TRACK-LIGHTS.jpeg',
            title: 'TRACK-LIGHTS',
            alt: 'Pendants Lights'
        },
        {
            id: 3,
            imgSrc: '/images/STRIP-LIGHTS.png',
            title: 'STRIP-LIGHTS',
            alt: 'Outdoor Lamps'
        }
    ];

    return (
        <div>
            <div className="container my-5">
                <div className="row text-center">
                    {/* Map through the gallery items */}
                    {galleryItems.map(item => (
                        <div className="col-md-4 mt-5" key={item.id}>
                            <div className="card">
                                <img src={item.imgSrc} className="card-img-top img-fluid" alt={item.alt} />
                                <div className="card-body mx-5">
                                    <h5 className="card-title">{item.title}</h5>
                                    <hr />
                                </div>
                            </div>
                        </div>
                    ))}
                </div>
                <div className="d-flex justify-content-center mt-4">
                    <Link href='/products'>
                        <button className='button' style={{ borderRadius: '0' }}>See More</button>
                    </Link>
                </div>
            </div>
        </div>
    );
}

export default Gallery;
