import Link from 'next/link'
import React from 'react'
import OfferBanner from "../OfferBaneer"

const AboutSummary = () => {
    return (
        <div>
            
            <OfferBanner/>

            <section className=" my-5 py-5 bg-light">
                <div className="container">
                    <h2 className="text-center mb-4 ">Arabian Lights</h2>
                    <p className="text-center">
                        Arabian Lights specializes in providing high-quality lighting solutions and decorative lights that enhance the beauty and functionality of any space. With a diverse range of products, from elegant chandeliers to modern floor lamps, we cater to both residential and commercial clients, ensuring that every corner is beautifully illuminated.
                    </p>
                    <p className="text-center">
                        At the core of our philosophy is a commitment to craftsmanship and innovation. We source the finest materials and employ cutting-edge technology to create lighting solutions that are not only aesthetically pleasing but also energy-efficient. Our designs range from classic to contemporary, allowing customers to find the perfect fit for their unique style and needs.
                    </p>
                   
                </div>
                <div className="d-flex justify-content-center mt-5">

                    <Link href='/about'>
                        <button className='button ' style={{ borderRadius: '0' }}>Read More</button>
                    </Link>

                </div>
            </section>



        </div>
    )
}

export default AboutSummary
