import React from 'react'

const AboutDetails = () => {
    return (
        <div>
            <section className=" my-5 py-5 bg-light">
                <div className="container">
                    <h2 className="text-center mb-4 ">Arabian Lights</h2>
                    <p className="text-center">
                        Arabian Lights specializes in providing high-quality lighting solutions and decorative lights that enhance the beauty and functionality of any space. With a diverse range of products, from elegant chandeliers to modern floor lamps, we cater to both residential and commercial clients, ensuring that every corner is beautifully illuminated.
                    </p>
                    <p className="text-center">
                        At the core of our philosophy is a commitment to craftsmanship and innovation. We source the finest materials and employ cutting-edge technology to create lighting solutions that are not only aesthetically pleasing but also energy-efficient. Our designs range from classic to contemporary, allowing customers to find the perfect fit for their unique style and needs.
                    </p>
                    <p className="text-center">
                        We understand that lighting is a crucial element in setting the mood and atmosphere of a space. Our dedicated team of experts provides personalized consultations to help clients choose the right products that suit their preferences and requirements. Additionally, we offer installation services to ensure that every piece is perfectly placed and functions optimally.
                    </p>
                    <p className="text-center">
                        As a business, we prioritize customer satisfaction and aim to create lasting relationships with our clients. We believe that every project is an opportunity to transform a space, and we are passionate about bringing light into homes and businesses alike.
                    </p>
                    <p className="text-center">
                        Explore our collection and discover how our lights can elevate your environment, making it more inviting, stylish, and functional.
                    </p>
                </div>

            </section>

            <section className="my-5 py-5">
                <div className="container">
                    <div className="row align-items-center">
                        <h2 className="mb-4 text-center">MISSION</h2>
                        <div className="col-lg-8 px-lg-5">
                            <p>
                                Our mission at Arabian Lights is to create exceptional lighting solutions
                                by illuminating spaces with elegance that transform environments,
                                evoke emotions, enhance architecture, and leave a lasting impression.
                                We blend innovation, craftsmanship, and sustainability to brighten.
                                homes, offices, and public spaces.
                            </p>
                            <p>
                                We believe in balancing aesthetics,
                                quality, and environmental responsibility. We aim to create enduring
                                relationships with our clients through personalized solutions and
                                unparalleled customer support.

                            </p>
                        </div>
                        <div className="col-lg-4">
                            <div class="card p-3">
                                <img src="/images/mission.jpg" class="card-img-top img-fluid" alt="MissionImage" />

                            </div>
                            {/* <img src="/images/mission.jpg" alt="MissionImage" className="img-fluid" /> */}
                        </div>
                    </div>
                </div>
            </section>

            <section className="my-5 py-5">
                <div className="container">
                    <h2 className="mb-4 text-center">VISION</h2>
                    <div className="row align-items-center">
                        <div className="col-lg-4">
                            <div class="card p-3">
                                <img src="/images/vision.jpg" class="card-img-top img-fluid" alt="MissionImage" />
                            </div>
                        </div>

                        <div className="col-lg-8 px-lg-5">
                            <p>
                                Our vision is to revolutionize the way people experience light. We aspire
                                to create designs that not only illuminate spaces but also evoke wonder,
                                inspire creativity, and enhance well-being.
                            </p>
                            <p>
                                We envision a world where
                                our luminaires contribute to energy efficiency, beauty, and harmony in
                                every environment. Together, we light up a brighter future.
                            </p>
                        </div>

                    </div>
                </div>
            </section>


        </div>
    )
}

export default AboutDetails
